/****************************************************************************

  File:           MICRELKS8721.h

-----------------------------------------------------------------------------

  Project:

-----------------------------------------------------------------------------

  Description:
    Declarations for Common Phy Register

-----------------------------------------------------------------------------

  Todo:

-----------------------------------------------------------------------------

  Changes:

    Name   Date          Version  Description
    -----------------------------------------------------------------------
    SB     10-January-2006   1.000    Initial release

****************************************************************************/

#ifndef __PHY_GENERIC_h_included
#define __PHY_GENERIC_h_included


#define PHY_BASIC_REG_CONTROL                    (0x00)
#define PHY_BASIC_REG_CONTROL_RESET                 (0x8000)
#define PHY_BASIC_REG_CONTROL_LOOPBACK              (0x4000)
#define PHY_BASIC_REG_CONTROL_SPEED_SEL_100         (0x2000)
#define PHY_BASIC_REG_CONTROL_AUTONEG_ENABLE        (0x1000)
#define PHY_BASIC_REG_CONTROL_POWERDOWN             (0x0800)
#define PHY_BASIC_REG_CONTROL_ISOLATE               (0x0400)
#define PHY_BASIC_REG_CONTROL_RESTART_AUTONEG       (0x0200)
#define PHY_BASIC_REG_CONTROL_FULL_DUPLEX           (0x0100)
#define PHY_BASIC_REG_CONTROL_COL_TEST              (0x0080)

#define PHY_BASIC_REG_STATUS                      (0x01)
#define PHY_BASIC_REG_STATUS_100T4_CAPABLE          (0x8000)
#define PHY_BASIC_REG_STATUS_100TX_FDX_CAPABLE      (0x4000)
#define PHY_BASIC_REG_STATUS_100TX_HDX_CAPABLE      (0x2000)
#define PHY_BASIC_REG_STATUS_10_FDX_CAPABLE         (0x1000)
#define PHY_BASIC_REG_STATUS_10_HDX_CAPABLE         (0x0800)
#define PHY_BASIC_REG_STATUS_NO_PREAMBLE            (0x0040)
#define PHY_BASIC_REG_STATUS_AUTONEG_COMPLETE       (0x0020)
#define PHY_BASIC_REG_STATUS_REMOTE_FAULT           (0x0010)
#define PHY_BASIC_REG_STATUS_AUTONEG_ABILITY        (0x0008)
#define PHY_BASIC_REG_STATUS_LINK_IS_UP             (0x0004)
#define PHY_BASIC_REG_STATUS_JABBER_DETECT          (0x0002)
#define PHY_BASIC_REG_STATUS_EXTENDED_CAPS          (0x0001)

#define PHY_BASIC_REG_ID_1                        (0x02)

#define PHY_BASIC_REG_ID_2                        (0x03)

#define PHY_EXTD_REG_AUTONEG_ADV                  (0x04)
#define PHY_EXTD_REG_AUTONEG_ADV_NEXT_PAGE_CAPABLE  (0x8000)
#define PHY_EXTD_REG_AUTONEG_ADV_REMOTE_FAULT       (0x2000)
#define PHY_EXTD_REG_AUTONEG_ADV_PAUSE              (0x0400)
#define PHY_EXTD_REG_AUTONEG_ADV_100T4_CAPABLE      (0x0200)
#define PHY_EXTD_REG_AUTONEG_ADV_100TX_FDX_CAPABLE  (0x0100)
#define PHY_EXTD_REG_AUTONEG_ADV_100TX_HDX_CAPABLE  (0x0080)
#define PHY_EXTD_REG_AUTONEG_ADV_10TX_FDX_CAPABLE   (0x0040)
#define PHY_EXTD_REG_AUTONEG_ADV_10TX_HDX_CAPABLE   (0x0020)
#define PHY_EXTD_REG_AUTONEG_ADV_SELECTOR_FLD_MASK  (0x001F)
#define PHY_EXTD_REG_AUTONEG_ADV_IEEE802_3          (0x0001)

#define PHY_EXTD_REG_AUTONEG_LINKPARTNER_ABILITY  (0x05)
#define PHY_EXTD_REG_AUTONEG_LPA_NEXT_PAGE_CAPABLE  (0x8000)
#define PHY_EXTD_REG_AUTONEG_LPA_ACKNOWLEDGE        (0x4000)
#define PHY_EXTD_REG_AUTONEG_LPA_REMOTE_FAULT       (0x2000)
#define PHY_EXTD_REG_AUTONEG_LPA_PAUSE              (0x0400)
#define PHY_EXTD_REG_AUTONEG_LPA_100T4_CAPABLE      (0x0200)
#define PHY_EXTD_REG_AUTONEG_LPA_100TX_FDX_CAPABLE  (0x0100)
#define PHY_EXTD_REG_AUTONEG_LPA_100TX_HDX_CAPABLE  (0x0080)
#define PHY_EXTD_REG_AUTONEG_LPA_10TX_FDX_CAPABLE   (0x0040)
#define PHY_EXTD_REG_AUTONEG_LPA_10TX_HDX_CAPABLE   (0x0020)
#define PHY_EXTD_REG_AUTONEG_LPA_SELECTOR_FLD_MASK  (0x001F)
#define PHY_EXTD_REG_AUTONEG_LPA_IEEE802_3          (0x0001)

#define PHY_EXTD_REG_AUTONEG_EXP_REG              (0x06)
#define PHY_EXTD_REG_AUTONEG_EXP_PAR_DETECT_FAULT   (0x0010)
#define PHY_EXTD_REG_AUTONEG_EXP_LP_NEXT_PAGE_ABLE  (0x0008)
#define PHY_EXTD_REG_AUTONEG_EXP_NEXT_PAGE_ABLE     (0x0004)
#define PHY_EXTD_REG_AUTONEG_EXP_PAGE_RCVD          (0x0002)
#define PHY_EXTD_REG_AUTONEG_EXP_LP_AUTONEG_ABLE    (0x0001)

#define PHY_EXTD_REG_NEXT_PAGE_TRANSMIT_REG       (0x07)
#define PHY_EXTD_REG_NEXT_PAGE_NEXT_PAGE            (0x8000)
#define PHY_EXTD_REG_NEXT_PAGE_MESSAGE_PAGE         (0x2000)
#define PHY_EXTD_REG_NEXT_PAGE_ACKNOWLEDGE2         (0x1000)
#define PHY_EXTD_REG_NEXT_PAGE_TOGGLE               (0x0800)
#define PHY_EXTD_REG_NEXT_PAGE_MESSAGE_FIELD        (0x07FF)

#endif
